 aR  w Q m
Z<      h	 oP      nSystem-wide
NAME PatchCalls

DGROUP GROUP DATA
SYSDEP_CGROUP GROUP SYSDEP_CODE

;EXTRN  RedoLists:FAR
;EXTRN  FindThisTitle:FAR

SYSDEP_CODE SEGMENT PUBLIC 'CODE'

EXTRN ConCatLitsPatch: FAR
EXTRN NewStringLitPatch: FAR
EXTRN SubStringLitPatch: FAR

EXTRN CompareBytesPatch: FAR
EXTRN FindBytePatch: FAR

SYSDEP_CODE ENDS


PUBLIC CcIntrEntry


ASSUME CS:DGROUP

concatLitsCall    EQU 060H
newStringLitCall  EQU 06BH
subStringLitCall  EQU 06CH

compareBytesCall  EQU 06FH
findByteCall      EQU 071H

findThisTitleCall EQU 025H
redoListsCall     EQU 0B2H


DATA SEGMENT PARA PUBLIC 'DATA'

; Data storage

EXTRN ccOldOff: WORD
EXTRN ccOldSeg: WORD  ; address of original entry points


CcIntrEntry LABEL FAR
  JMP  SHORT CcInterruptEntry

CcIndrEntry:
  JMP  SHORT CcIndirectEntry

CcInterruptEntry:
  POP  BX          ; get IP
  POP  ES          ; get CS
  POPF             ; set flags

  MOV  AX, ES:[BX] ; get call #
  XOR  AH, AH
  INC  BX          ; skip call #

  PUSH ES          ; push CS
  PUSH BX          ; push IP

CcIndirectEntry:   ; Now AX holds routine num
  CMP  AL, redoListsCall
  JNE  MaybeFindThisTitle

; I can do this instead of a jump because there are no parms for RedoLists

; CALL RedoLists   ; Need to go thru Interrupt to bank in ROM/EMS
  INT  70H         ; OsCalls interrupt
  DB   148         ; Call number for redo lists patch

CcLongRet1 PROC FAR
  RET
CcLongRet1 ENDP

MaybeFindThisTitle:
  CMP  AL, findThisTitleCall
  JNE  MaybeConcatLits

; Push the parms on the stack (again!) before calling FindThisTitlePatch
; (Not as simple as the RedoLists Patch was)

  POP  BX          ; Save IP
  POP  ES          ; Save CS

  POP  CX          ; OFFSET pError
  POP  DX          ; SEG    pError
  POP  DI          ; OFFSET pTitle
  POP  SI          ; SEG    pTitle

  PUSH ES          ; RETURN CS
  PUSH BX          ; RETURN IP

  PUSH SI          ; SEG    pTitle
  PUSH DI          ; OFFSET pTitle
  PUSH DX          ; SEG    pError
  PUSH CX          ; OFFSET pError

; CALL FindThisTitle  ; Need to go thru Interrupt to bank in ROM/EMS
  INT  70H            ; OsCalls interrupt
  DB   149            ; Call number for find this title patch

CcLongRet2 PROC FAR
  RET
CcLongRet2 ENDP

MaybeConcatLits:
  CMP  AL, concatLitsCall
  JNE  MaybeNewStringLit

  MOV  BX, OFFSET SYSDEP_CGROUP:ConcatLitsPatch
  JMP  SHORT LongJumpToSysdepCGroup

MaybeNewStringLit:
  CMP  AL, newStringLitCall
  JNE  MaybeSubStringLit

  MOV  BX, OFFSET SYSDEP_CGROUP:NewStringLitPatch
  JMP  SHORT LongJumpToSysdepCGroup

MaybeSubStringLit:
  CMP  AL, subStringLitCall
  JNE  MaybeCompareBytes

  MOV  BX, OFFSET SYSDEP_CGROUP:SubStringLitPatch
  JMP  SHORT LongJumpToSysdepCGroup

MaybeCompareBytes:
  CMP  AL, compareBytesCall
  JNE  MaybeFindByte

  MOV  BX, OFFSET SYSDEP_CGROUP:CompareBytesPatch
  JMP  SHORT LongJumpToSysdepCGroup

MaybeFindByte:
  CMP  AL, findByteCall
  JNE  GiveBackToCommonCode

  MOV  BX, OFFSET SYSDEP_CGROUP:FindBytePatch
  JMP  SHORT LongJumpToSysdepCGroup

GiveBackToCommonCode:
  MOV  ES, CS:ccOldSeg    ; In this case, CS should be DS which
  MOV  BX, CS:ccOldOff    ; should be pointing to DGROUP

  INC  BX          ; get addr of
  INC  BX          ; indirect
  JMP  SHORT LongJumpLabel

LongJumpToSysdepCGroup:
  PUSH BX
  MOV  BX, SYSDEP_CGROUP
  MOV  ES, BX
  POP  BX

LongJumpLabel:
  PUSH ES          ; push CS
  PUSH BX          ; push IP

CcFakeALongJump PROC FAR
  RET
CcFakeALongJump ENDP


DATA ENDS
     END
